function equalHeights(elem) {
    var h = 0;
    $(elem).removeAttr('style').each(function(){
        var newH = $(this).height();
        h = (newH > h) ? newH : h;
    }).height(h);
}

jQuery(function($) {
    $(window).resize(function(){equalHeights('.more-recipes h3 span')}).resize();
    setTimeout(function(){equalHeights('.more-recipes h3 span')}, 100);

    // Find all videos
    var $allVideos = $(".video-wrapper iframe");

    // Figure out and save aspect ratio for each video
    $allVideos.each(function() {
        $(this)
            .data('aspectRatio', this.height / this.width)
            // and remove the hard coded width/height
            .removeAttr('height')
            .removeAttr('width');
    });

    // When the window is resized
    $(window).resize(function() {
        var newWidth = $(".video-wrapper").width();
        // Resize all videos according to their own aspect ratio
        $allVideos.each(function() {
            var $el = $(this);
            $el
                .width(newWidth)
                .height(newWidth * $el.data('aspectRatio'));

        });
    }).resize();
});